% finaquant Financial Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu 2012, version: 24April2012
% Function: Simulate total returns for different share classes
% Related web page:
% http://finaquant.com/fee-calculator-and-analyzer-for-share-classes-of-mutual-funds-1-calculation/991
function [TotalFundReturn, FinalAssetValue] =     SimulateTotalReturns( ...                           ...
    InputParameters,    ... % front-end load, fee rates, back-end load etc.
    Nmax,               ... % upper limit to periods for simulation (1,2, ... Nmax)
    MaxReturn,          ... % upper limit to assumed fixed returns (1,2,... MaxReturn)
    SharePrice,         ... % initial purchase price of a share
    MaxShareInd,        ... % #shares = [1,2,... MaxShareInd] * ShareMultiplier
    ShareMultiplier)

% number of share classes
CountShareClasses = length(InputParameters)

for ShareClassNo = 1:CountShareClasses
    % read all inputs from InputParameters
    FrondEndLoadRates = InputParameters(ShareClassNo).FrontEndLoadRates;
    BackEndLoadCDSCRates = InputParameters(ShareClassNo).BackEndLoadCDSC;
    AnnualDistributionFeeRate = InputParameters(ShareClassNo).DistrFeeRate;
    AnnualManagementFeeRates = InputParameters(ShareClassNo).MngFeeRates;
    MngFeeScaleLogic = InputParameters(ShareClassNo).MngFeeScaleLogic;
    OtherAnnualServiceFeeRates = InputParameters(ShareClassNo).ServiceFeeRates;
    OtherSubscriptionFeeRates = InputParameters(ShareClassNo).SubsFeeRates;
    OtherRedemptionFeeRates = InputParameters(ShareClassNo).RedempFeeRates;

    for IndShares = 1:MaxShareInd
        NumberOfShares = IndShares * ShareMultiplier;
        
        for N = 1:Nmax
            for AssumedFixedReturn = 1:MaxReturn
                AssumedFundReturns = AssumedFixedReturn * ones(1,N);
                
                % call fee calculation function
                [ResultMatrix,     ...     % stores all intermediate results, a row for each period (year)
                    ResultMatrixFields,     ...     % field (column) names of result matrix in a cell array
                    EffectiveFundReturns,   ...     % effective fund returns for each period after all fees
                    EffectiveAssetValue]    ...     % effective total asset values for each period after all fees
                    = FeeCalculator_MultiPeriod(    ...
                    FrondEndLoadRates,              ...
                    BackEndLoadCDSCRates,           ...
                    AnnualDistributionFeeRate,      ...
                    AnnualManagementFeeRates,       ...
                    MngFeeScaleLogic,               ...
                    OtherAnnualServiceFeeRates,     ...
                    OtherSubscriptionFeeRates,      ...
                    OtherRedemptionFeeRates,        ...
                    AssumedFundReturns,             ...
                    SharePrice,                     ...     % gross subscription price
                    NumberOfShares,                 ...     % number of shares
                    N);
                
                % store results in multi-dimensional arrays
                TotalFundReturn(ShareClassNo,IndShares,N,AssumedFixedReturn) = ((EffectiveAssetValue(N) / (NumberOfShares * SharePrice))-1) * 100;
                FinalAssetValue(ShareClassNo,IndShares,N,AssumedFixedReturn) = EffectiveAssetValue(N);
            end
        end
    end
end


    
    
    